/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.entity.npc;

import lotr.common.LOTRAchievement;
import lotr.common.LOTRLevelData;
import lotr.common.LOTRMod;
import lotr.common.LOTRPotions;
import lotr.common.entity.animal.LOTREntityCamel;
import lotr.common.entity.npc.LOTREntityNPC;
import lotr.common.entity.npc.LOTREntityNomad;
import lotr.common.entity.npc.LOTRNPCMount;
import lotr.common.entity.npc.LOTRTradeEntries;
import lotr.common.entity.npc.LOTRTravellingTrader;
import lotr.common.item.LOTRItemHaradRobes;
import lotr.common.item.LOTRItemHaradTurban;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.world.World;

public class LOTREntityNomadMerchant
extends LOTREntityNomad
implements LOTRTravellingTrader {
    private static int[] robeColors = new int[]{15723226, 13551017, 6512465, 2499615, 11376219, 7825215};

    public LOTREntityNomadMerchant(World world) {
        super(world);
        this.addTargetTasks(false);
        this.spawnRidingHorse = this.field_70146_Z.nextInt(4) == 0;
    }

    @Override
    public LOTRNPCMount createMountToRide() {
        LOTREntityCamel horse = (LOTREntityCamel)super.createMountToRide();
        horse.setMountArmor(null);
        return horse;
    }

    @Override
    public LOTRTradeEntries getBuyPool() {
        return LOTRTradeEntries.NOMAD_MERCHANT_BUY;
    }

    @Override
    public void func_70645_a(DamageSource source) {
        super.func_70645_a(source);
        if (source.func_76346_g() instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)source.func_76346_g();
            player.func_70690_d(new PotionEffect(LOTRPotions.curse.field_76415_H, 24000, 0));
        }
    }

    public int func_70658_aO() {
        return 12;
    }

    @Override
    public LOTRTradeEntries getSellPool() {
        return LOTRTradeEntries.NOMAD_MERCHANT_SELL;
    }

    @Override
    public LOTREntityNPC createTravellingEscort() {
        return new LOTREntityNomad(this.field_70170_p);
    }

    @Override
    public String getDepartureSpeech() {
        return "nearHarad/nomad/merchant/departure";
    }

    @Override
    public IEntityLivingData func_110161_a(IEntityLivingData data) {
        data = super.func_110161_a(data);
        this.npcItemsInv.setIdleItem(new ItemStack(LOTRMod.pouch, 1, 3));
        int robeColor = robeColors[this.field_70146_Z.nextInt(robeColors.length)];
        ItemStack[] robe = new ItemStack[]{new ItemStack(LOTRMod.bootsHaradRobes), new ItemStack(LOTRMod.legsHaradRobes), new ItemStack(LOTRMod.bodyHaradRobes), new ItemStack(LOTRMod.helmetHaradRobes)};
        for (ItemStack item : robe) {
            LOTRItemHaradRobes.setRobesColor(item, robeColor);
        }
        if (this.field_70146_Z.nextBoolean()) {
            LOTRItemHaradTurban.setHasOrnament(robe[3], true);
        }
        this.func_70062_b(1, robe[0]);
        this.func_70062_b(2, robe[1]);
        this.func_70062_b(3, robe[2]);
        this.func_70062_b(4, robe[3]);
        return data;
    }

    @Override
    public float getAlignmentBonus() {
        return 2.0f;
    }

    @Override
    public boolean canTradeWith(EntityPlayer entityplayer) {
        return LOTRLevelData.getData(entityplayer).getAlignment(this.getFaction()) >= 0.0f && this.isFriendly(entityplayer);
    }

    @Override
    public void onPlayerTrade(EntityPlayer entityplayer, LOTRTradeEntries.TradeType type, ItemStack itemstack) {
        LOTRLevelData.getData(entityplayer).addAchievement(LOTRAchievement.tradeNomadMerchant);
    }

    @Override
    public boolean shouldTraderRespawn() {
        return false;
    }

    @Override
    public String getSpeechBank(EntityPlayer entityplayer) {
        if (this.isFriendlyAndAligned(entityplayer)) {
            return "nearHarad/nomad/merchant/friendly";
        }
        return "nearHarad/nomad/merchant/hostile";
    }
}

